/*
 * Decompiled with CFR 0.152.
 */
package processing.core;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import processing.core.PException;
import processing.core.PMIDlet;
import processing.core.PRequest;

public class PClient {
    protected PMIDlet midlet;
    protected String server;
    protected int port;

    public PClient(PMIDlet pMIDlet, String string) {
        this(pMIDlet, string, 80);
    }

    public PClient(PMIDlet pMIDlet, String string, int n) {
        this.midlet = pMIDlet;
        this.server = string;
        this.port = n;
    }

    public static String encode(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (Character.isDigit(c) || Character.isLowerCase(c) || Character.isUpperCase(c)) {
                stringBuffer.append(c);
                continue;
            }
            if (c == ' ') {
                stringBuffer.append('+');
                continue;
            }
            stringBuffer.append('%');
            if (c < '\u0010') {
                stringBuffer.append('0');
            }
            stringBuffer.append(Integer.toHexString(c));
        }
        return stringBuffer.toString();
    }

    public PRequest GET(String string) {
        return this.request(string, null, null);
    }

    public PRequest GET(String string, String[] stringArray, String[] stringArray2) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string);
        stringBuffer.append("?");
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            stringBuffer.append(stringArray[i]);
            stringBuffer.append("=");
            stringBuffer.append(PClient.encode(stringArray2[i]));
            if (i >= n - 1) continue;
            stringBuffer.append("&");
        }
        return this.GET(stringBuffer.toString());
    }

    public PRequest POST(String string, String[] stringArray, String[] stringArray2) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        PrintStream printStream = new PrintStream(byteArrayOutputStream);
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            if (i > 0) {
                printStream.print("&");
            }
            printStream.print(PClient.encode(stringArray[i]));
            printStream.print("=");
            printStream.print(PClient.encode(stringArray2[i]));
        }
        return this.request(string, "application/x-www-form-urlencoded", byteArrayOutputStream.toByteArray());
    }

    public PRequest POST(String string, String[] stringArray, Object[] objectArray) {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            PrintStream printStream = new PrintStream(byteArrayOutputStream);
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                printStream.print("--BOUNDARY_185629\r\n");
                printStream.print("Content-Disposition: form-data; name=\"");
                printStream.print(stringArray[i]);
                if (objectArray[i] instanceof String) {
                    printStream.print("\"\r\n");
                    printStream.print("\r\n");
                    printStream.print((String)objectArray[i]);
                    printStream.print("\r\n");
                    continue;
                }
                if (!(objectArray[i] instanceof byte[])) continue;
                byte[] byArray = (byte[])objectArray[i];
                printStream.print("\"; filename=\"");
                printStream.print(stringArray[i]);
                printStream.print("\"\r\n");
                printStream.print("Content-Type: application/octet-stream\r\n");
                printStream.print("Content-Transfer-Encoding: binary\r\n\r\n");
                ((OutputStream)printStream).write(byArray);
                printStream.print("\r\n");
            }
            printStream.print("--BOUNDARY_185629--\r\n\r\n");
            return this.request(string, "multipart/form-data; boundary=BOUNDARY_185629", byteArrayOutputStream.toByteArray());
        }
        catch (IOException iOException) {
            throw new PException(iOException);
        }
    }

    protected PRequest request(String string, String string2, byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("http://");
        stringBuffer.append(this.server);
        if (this.port != 80) {
            stringBuffer.append(":");
            stringBuffer.append(this.port);
        }
        stringBuffer.append(string);
        PRequest pRequest = new PRequest(this.midlet, stringBuffer.toString(), string2, byArray);
        Thread thread = new Thread(pRequest);
        thread.start();
        return pRequest;
    }
}

